<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    public function client()
    {
        return $this->belongsTo('App\Models\Client', 'client_id');
    }

    public function assigned()
    {
        return $this->belongsTo('App\Models\User', 'assigned_id');
    }

    public function createdBy()
    {
        return $this->hasOne('App\Models\User', 'id', 'created_id');
    }

    public function updatedBy()
    {
        return $this->hasOne('App\Models\User', 'id', 'updated_id');
    }

}